/*
 * Decompiled with CFR 0.152.
 */
package no.statkart.launcher.client;

import java.io.FileNotFoundException;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import javax.net.ssl.SSLException;
import no.statkart.launcher.client.Parametre;

class Feil {
    private final Exception exception;
    private final Parametre inputParametre;
    private final boolean redFlag;

    Feil(Exception exception, Parametre inputParametre) {
        this(exception, inputParametre, true);
    }

    Feil(Exception exception, Parametre inputParametre, boolean redFlag) {
        this.inputParametre = inputParametre;
        this.exception = exception;
        this.redFlag = redFlag;
    }

    boolean erTjenerfeil() {
        return this.exception instanceof MalformedURLException || this.exception instanceof FileNotFoundException || this.exception instanceof SSLException || this.exception instanceof ConnectException || this.exception instanceof UnknownHostException || this.harTjenersuffiks() || this.erUgyldigTjenerformat();
    }

    boolean erHeapFeil() {
        return this.exception instanceof NumberFormatException;
    }

    boolean erBrukerPassordFeil() {
        return !this.erTjenerfeil() && !this.erHeapFeil();
    }

    Parametre getInputParametre() {
        return this.inputParametre;
    }

    boolean erRedFlag() {
        return this.redFlag;
    }

    String tilFeilmelding() {
        if (this.exception instanceof MalformedURLException) {
            return "Feil inntastet tjeneradresse. Skal v\u00e6re p\u00e5 formatet <protokoll>://<tjener>[:<port>]";
        }
        if (this.harTjenersuffiks()) {
            return "Feil inntastet tjeneradresse. Skal bare ha tjenernavn.";
        }
        if (this.erUgyldigTjenerformat()) {
            return "Feil inntastet tjeneradresse. Skal v\u00e6re p\u00e5 formatet <protokoll>://<tjener>[:<port>]";
        }
        if (this.exception instanceof FileNotFoundException) {
            return "Tjenerfeil. Vennligst kontroller om dette er en gyldig tjener.";
        }
        if (this.exception instanceof SSLException) {
            return "Sertifikatfeil. Vennligst kontroller nettverksoppsettet.";
        }
        if (this.exception instanceof ConnectException || this.exception instanceof UnknownHostException) {
            return "Ikke kontakt med tjener, sjekk nettilkobling";
        }
        if (this.exception instanceof NumberFormatException) {
            return "Minnest\u00f8rrelse m\u00e5 skrives inn som et heltall";
        }
        return "Gyldig brukernavn og passord er p\u00e5krevd";
    }

    private boolean harTjenersuffiks() {
        try {
            String tjener = this.inputParametre.getTjener();
            return !"".equals(new URL(tjener).getPath().replaceFirst("/", ""));
        }
        catch (MalformedURLException e) {
            return true;
        }
    }

    private boolean erUgyldigTjenerformat() {
        String tjener = this.inputParametre.getTjener();
        return tjener == null || !tjener.matches("^[\\w]+://[^/]+/?$");
    }
}

