/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.getdown.data;

import com.threerings.getdown.util.VersionUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class SysProps {
    public static String appDir() {
        return System.getProperty("appdir");
    }

    public static String appId() {
        return System.getProperty("appid");
    }

    public static String appBase() {
        return System.getProperty("appbase");
    }

    public static boolean noLogRedir() {
        return System.getProperty("no_log_redir") != null;
    }

    public static boolean debug() {
        return System.getProperty("debug") != null;
    }

    public static String appbaseDomain() {
        return System.getProperty("appbase_domain");
    }

    public static String appbaseOverride() {
        return System.getProperty("appbase_override");
    }

    public static boolean silent() {
        return System.getProperty("silent") != null;
    }

    public static boolean launchInSilent() {
        return "launch".equals(System.getProperty("silent"));
    }

    public static boolean noUpdate() {
        return "noupdate".equals(System.getProperty("silent"));
    }

    public static boolean noInstall() {
        return System.getProperty("no_install") != null;
    }

    public static int startDelay() {
        return Math.min(Math.max(Integer.getInteger("delay", 0), 0), 1440);
    }

    public static boolean noUnpack() {
        return Boolean.getBoolean("no_unpack");
    }

    public static boolean direct() {
        return Boolean.getBoolean("direct");
    }

    public static boolean tryNoProxyFirst() {
        return Boolean.getBoolean("try_no_proxy");
    }

    public static int connectTimeout() {
        return Integer.getInteger("connect_timeout", 0);
    }

    public static int readTimeout() {
        return Integer.getInteger("read_timeout", 30);
    }

    public static int threadPoolSize() {
        int n2 = Math.max(Runtime.getRuntime().availableProcessors() - 1, 1);
        return Integer.getInteger("thread_pool_size", n2);
    }

    public static long parseJavaVersion(String string, String string2) {
        String string3 = System.getProperty(string);
        if (string3 == null) {
            throw new IllegalArgumentException("No system property '" + string + "'.");
        }
        long l2 = VersionUtil.parseJavaVersion(string2, string3);
        if (l2 == 0L) {
            throw new IllegalArgumentException("Regexp '" + string2 + "' does not match '" + string3 + "' (from " + string + ")");
        }
        return l2;
    }

    public static String overrideAppbase(String string) {
        String string2 = SysProps.appbaseOverride();
        if (string2 != null) {
            return string2;
        }
        return SysProps.replaceDomain(string);
    }

    public static String replaceDomain(String object) {
        String string = SysProps.appbaseDomain();
        if (string != null) {
            object = Pattern.compile("(https?://[^/]+)(.*)").matcher((CharSequence)object);
            object = ((Matcher)object).replaceAll(string + "$2");
        }
        return object;
    }
}

